Include([[Data/levels/include/level_utils.lua]])

Level =
{
	MapSkinFilename = [[jungle.lua]],
	MapGenScript = LevelUtils.MapGenFromSVG([[tutorial_research.svg]]),
	Parameters =
	{
		MarineCount 		= 5,
		StartBPMultiplier 	= 1.5,
		BPGainMultiplier 	= 1.0,
		MaxHiveLevel 		= 4,
		MaxSpawnRate 		= 0.0,
	},
	Mutations =
	{
		CapturesPerMutation = 1,
		MaxMutations = 2,
		Default = [[disabled]],
		Active =
		{
		},
		Queue =
		{
			[[ZU_NONE]],
			[[ZU_RUST]],
			[[ZU_HIVE_SPIKES]],
		},
		Disabled =
		{
		},
	},
	MarineUpgrades = 
	{
		--Default = [[locked]],
		Active =
		{
		},
		Inactive =
		{
			[[MU_CHOPPER]],
		},	
		Locked =
		{
		},			
	}
}

ai_team = {}

function ActivateStrikePlan(p_pointName, p_marineIndices)

	if p_marineIndices == nil then
		p_marineIndices = {}
		for i=1, #ai_team do
			table.insert(p_marineIndices, i)
		end
	end

	local strikeArea = GameWorld:GetEntityById(p_pointName);
	local marine = ai_team[3]:GetPtr();

	if not strikeArea then
		return
	end	
	
	
	for _,i in pairs(p_marineIndices) do
		local deltaV = vect2f.MakePolar(strikeArea:GetRadius()*3, i/#ai_team*math.pi*2)
		
		local marine = ai_team[i]:GetPtr();
		
		if marine then
			marine = marine:ToCHuman()
			
			if marine and not marine:GetIsBusy() then
			
                ScriptMgr:DoDelayedCall(GetRandomRange(0,1000),
                    function ()
                        marine:CommandAssaultTo(strikeArea:GetPos() + deltaV)                        
                        return false
                    end)
				
			end
		end
	end

end

------------------------------------------------------------------------------- Level Init
LevelInit = LevelUtils.MakeGoal(
	nil,
	{[[NT_BEGIN_GAME]]},
	function (self, p_type, p_entId, p_pos, p_other)		
		
		local text_hdl = GameWorld:ShowText("Those army fools are goin to rush in and get themselves killed\n\nMaybe we can drop in fast enough to save their ass", "Sarge")
		
		for i=1,5 do		
			local entHandle = EHandle(GameWorld:GetEntityById("aiSoldier"..i));	
			table.insert(ai_team, entHandle)
		end
		
		ActivateStrikePlan("firstPoint")
        ScriptMgr:DoDelayedCall(2500, 	function ()
                                            TeamDrop:Enable()
                                            return false
                                        end)
		
		self:Disable()
	end)
LevelInit:Enable()

------------------------------------------------------------------------------- Chopper Team Drop
TeamDrop = LevelUtils.MakeGoal(
	function (self)	
		local landingArea = GameWorld:GetEntityById("startPoint")
		if landingArea then
			local chopper = GameWorld:SpawnChopper(vect2f(-0.3, 1.0), landingArea:GetPos())
			chopper:SetMission(ChopperOrder.CO_DELIVERY, landingArea:GetPos(), "Marines")
		end
	end,
	
	{[[NT_CHOPPER_DELIVERY]]},
	function (self, p_type, p_entId, p_pos, p_other)
		
		if p_other ~= "Marines" then
			return
		end
		
		GameWorld:AddMarines(p_pos, GameWorld:GetStartingTeamSize())
	
		ResearchObjective:Enable()
	
		self:Disable()
	end)

	
------------------------------------------------------------------------------- Research Goal
ResearchObjective =  LevelUtils.MakeGoal(
	function (self)
		if GameWorld:GetObjectiveExists("researchgoal:" .. "MU_CHOPPER") then
			GameWorld:ChangeObjectiveStatus("researchgoal:" .. "MU_CHOPPER", [[incomplete]])
		else
			GameWorld:AddObjective("researchgoal:" .. "MU_CHOPPER", "Build " .. "Helistrike" .. " Tech Silo")
		end
		
		GameWorld:SetUIHighlightArrow("constructionMenu", "Toggle:Research", true)
		GameWorld:SetUIHighlight("researchMenu", "Research:" .. "MU_CHOPPER", true)
		
		self.text_hdl = GameWorld:ShowText("That is why we are going to call in air support\n\nBuild a tech station for airstrikes Drake", "Scout")
	end,
	
	{[[NT_TECH_RESEARCHED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		if p_other ~= "MU_CHOPPER" then
			return
		end

		GameWorld:ChangeObjectiveStatus("researchgoal:" .. "MU_CHOPPER", [[complete]])
		
		CaptureOneGoal:Enable()
		HelistrikeObjective:Enable()
		
		self:Disable()
	end,
	
	function (self)
		GameWorld:SetUIHighlightArrow("constructionMenu", "Toggle:Research", false)
		GameWorld:SetUIHighlight("researchMenu", "Research:" .. "MU_CHOPPER", false)
		self.text_hdl:ClearText()
	end)

------------------------------------------------------------------------------- Helistrike Goal
HelistrikeObjective =  LevelUtils.MakeGoal(
	function (self)
		self.heli_call_count = 0

        GameWorld:SetEntityVisible("heliArea1", true)
		GameWorld:SetEntityVisible("heliArea2", true)
		
		GameWorld:SetUIHighlightArrow("chopperGroup", "ChopperButton", true)
		
		self.text_hdl = GameWorld:ShowText("Time to call in the flyboys and blow some shit up", "Sarge")
	end,
	
	{[[NT_CHOPPER_STRIKE_ORDER]]},
	function (self, p_type, p_entId, p_pos, p_other)	

        local strikeArea = GameWorld:GetEntityById("heliArea1")
        if strikeArea and vect2f.IsDistLess(p_pos, strikeArea:GetPos(), strikeArea:GetRadius()/2) then
            strikeArea:SetIsInvisible(true)
        end

        local strikeArea = GameWorld:GetEntityById("heliArea2")
        if strikeArea and vect2f.IsDistLess(p_pos, strikeArea:GetPos(), strikeArea:GetRadius()/2) then
            strikeArea:SetIsInvisible(true)
        end

		self.heli_call_count = self.heli_call_count + 1
		
		if self.heli_call_count >= 2 then
		    self:Disable()
		    CaptureOneGoal.text_hdl = GameWorld:ShowText("Good job commander\n\nQuickly, capture the node before the aliens regenerate", "Scout")
		end
	end,
	
	function (self)
        GameWorld:SetEntityVisible("heliArea1", false)
		GameWorld:SetEntityVisible("heliArea2", false)
	
		GameWorld:SetUIHighlightArrow("chopperGroup", "ChopperButton", false)

		self.text_hdl:ClearText()
	end)	

	
------------------------------------------------------------------------------- Capture one point
CaptureOneGoal = LevelUtils.MakeGoal(
	function (self)
		--self.text_hdl = GameWorld:ShowText("Attack the fortified area with your team and capture the point")
		GameWorld:CreateTrainingArrow("firstPoint")
	end,
	
	{[[NT_POINT_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		if p_entId ~= "firstPoint" then
			return
		end
		
		self:Disable()
		HelistrikeObjective:Disable()
		
		GameWorld:SetSpawnRate(9.0)
		
		CaptureAllObjective:Enable()
	end,
	
	function (self)
		self.text_hdl:ClearText()
		GameWorld:RemoveTrainingArrow("firstPoint")
	end)
	
------------------------------------------------------------------------------- Tracked objective for capturing everything
CaptureAllObjective = LevelUtils.MakeGoal(
	function (self)
		GameWorld:SetUIVisibility("Objectives", true)
		GameWorld:AddObjective("winObj", "Capture all the enemy points")
		
		local text_hdl = GameWorld:ShowText("Let's sweep the area, team\n\nDon't leave none of them grubs alive", "Sarge")
		ScriptMgr:DoDelayedCall(8000, function () text_hdl:ClearText(); end)	
	end,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ChangeObjectiveStatus("winObj", [[complete]])
	
		self:Disable()
	end)
	
------------------------------------------------------------------------------- Victory Condition - Capture All Points (short-circuit)
CaptureAllGoal = LevelUtils.MakeGoal(
	nil,
	
	{[[NT_ALL_POINTS_CAPTURED]]},
	function (self, p_type, p_entId, p_pos, p_other)
		GameWorld:ClearText()
		GameWorld:GameOver(true)
		
		self:Disable()
	end) 
CaptureAllGoal:Enable()	

------------------------------------------------------------------------------- Mutation has happened!
MutationWatcher = LevelUtils.MakeGoal(
	function (self)
	end,
	
	{[[NT_MUTATION_EVOLVED]]},
	function (self, p_type, p_entId, p_pos, p_other)	
		
        local text_hdl = nil
        if p_other == "ZU_RUST" then
            text_hdl = GameWorld:ShowText("The aliens are mutating again, commander\n\nLooks like our structures are vulnerable to poison now", "Scout")
		elseif p_other == "ZU_HIVE_SPIKES" then
		    text_hdl = GameWorld:ShowText("Enzymes soften metal\n\nHow fare you with no steel slaves?", "Alien")
		else
		    return
		end
		
		ScriptMgr:DoDelayedCall(12000, function () text_hdl:ClearText(); end)
		
	end)
MutationWatcher:Enable()
	
function OnDebugCall(mousePos)

end